/*
 * Decompiled with CFR 0.152.
 */
package br.com.backforest.forestmonitor.controller;

import br.com.backforest.forestmonitor.dto.LeituraRecordDTO;
import br.com.backforest.forestmonitor.model.Leitura;
import br.com.backforest.forestmonitor.service.MonitoramentoService;
import java.time.LocalDate;
import java.util.List;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/leituras"})
public class LeituraController {
    private final MonitoramentoService service;

    public LeituraController(MonitoramentoService service) {
        this.service = service;
    }

    @PostMapping
    public ResponseEntity<String> receberDados(@RequestBody LeituraRecordDTO dados) {
        boolean foiSalvo = this.service.registrarLeitura(dados);
        if (foiSalvo) {
            return ResponseEntity.ok((Object)"Dados recebidos e persistidos com sucesso!");
        }
        return ResponseEntity.ok((Object)"Dados recebidos, mas ignorados (Duplicidade detectada).");
    }

    @GetMapping(value={"/dispositivo/{id}"})
    public ResponseEntity<List<Leitura>> buscarPorDispositivo(@PathVariable Long id, @RequestParam(required=false) LocalDate inicio, @RequestParam(required=false) LocalDate fim) {
        List lista = this.service.listarLeituras(id, inicio, fim);
        if (lista.isEmpty()) {
            return ResponseEntity.noContent().build();
        }
        return ResponseEntity.ok((Object)lista);
    }
}

